"use client"

import { Button } from "@/components/ui/button"
import { Card } from "@/components/ui/card"
import { Heart, Leaf, Eye, Activity, Phone, Mail, MapPin } from "lucide-react"
import { useState } from "react"

export default function ZdraviePo50() {
  const [activeSection, setActiveSection] = useState("domov")

  const scrollToSection = (sectionId: string) => {
    setActiveSection(sectionId)
    const element = document.getElementById(sectionId)
    if (element) {
      element.scrollIntoView({ behavior: "smooth" })
    }
  }

  return (
    <div className="min-h-screen bg-gradient-to-b from-white to-emerald-50/30">
      {/* Navigation */}
      <nav className="sticky top-0 z-50 bg-white/95 backdrop-blur-sm border-b border-emerald-100 shadow-sm">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="flex items-center justify-between h-16">
            <div className="flex items-center gap-2">
              <Heart className="h-8 w-8 text-emerald-600" />
              <span className="text-xl font-bold text-emerald-900">Zdravie po 50</span>
            </div>
            <div className="hidden md:flex items-center gap-6">
              <button
                onClick={() => scrollToSection("domov")}
                className={`text-sm font-medium transition-colors hover:text-emerald-600 ${
                  activeSection === "domov" ? "text-emerald-600" : "text-slate-700"
                }`}
              >
                Domov
              </button>
              <button
                onClick={() => scrollToSection("vyzhiva")}
                className={`text-sm font-medium transition-colors hover:text-emerald-600 ${
                  activeSection === "vyzhiva" ? "text-emerald-600" : "text-slate-700"
                }`}
              >
                Výživa a energia
              </button>
              <button
                onClick={() => scrollToSection("krvny-tlak")}
                className={`text-sm font-medium transition-colors hover:text-emerald-600 ${
                  activeSection === "krvny-tlak" ? "text-emerald-600" : "text-slate-700"
                }`}
              >
                Krvný tlak a rovnováha
              </button>
              <button
                onClick={() => scrollToSection("klby")}
                className={`text-sm font-medium transition-colors hover:text-emerald-600 ${
                  activeSection === "klby" ? "text-emerald-600" : "text-slate-700"
                }`}
              >
                Kĺby a pohyb
              </button>
              <button
                onClick={() => scrollToSection("oci")}
                className={`text-sm font-medium transition-colors hover:text-emerald-600 ${
                  activeSection === "oci" ? "text-emerald-600" : "text-slate-700"
                }`}
              >
                Zdravie očí
              </button>
              <button
                onClick={() => scrollToSection("kontakt")}
                className={`text-sm font-medium transition-colors hover:text-emerald-600 ${
                  activeSection === "kontakt" ? "text-emerald-600" : "text-slate-700"
                }`}
              >
                Kontakt
              </button>
            </div>
          </div>
        </div>
      </nav>

      {/* Hero Section */}
      <section id="domov" className="relative py-20 px-4 sm:px-6 lg:px-8">
        <div className="max-w-7xl mx-auto">
          <div className="grid lg:grid-cols-2 gap-12 items-center">
            <div className="space-y-6">
              <h1 className="text-4xl sm:text-5xl lg:text-6xl font-bold text-emerald-900 leading-tight text-balance">
                Vaša cesta k vitálnemu životu po 50-tke
              </h1>
              <p className="text-lg text-slate-600 leading-relaxed text-pretty">
                Objavte prírodné riešenia pre zdravie, energiu a pohodu. Podporujeme vás na ceste k aktívnemu a
                plnohodnotnému životu v každom veku.
              </p>
              <div className="flex flex-col sm:flex-row gap-4">
                <Button
                  size="lg"
                  className="bg-emerald-600 hover:bg-emerald-700 text-white px-8 py-6 text-lg"
                  onClick={() => scrollToSection("vyzhiva")}
                >
                  Začnite teraz
                </Button>
                <Button
                  size="lg"
                  variant="outline"
                  className="border-emerald-600 text-emerald-700 hover:bg-emerald-50 px-8 py-6 text-lg bg-transparent"
                  onClick={() => scrollToSection("kontakt")}
                >
                  Kontaktujte nás
                </Button>
              </div>
            </div>
            <div className="relative h-[400px] lg:h-[500px] rounded-2xl overflow-hidden shadow-2xl">
              <img
                src="/happy-active-senior-couple-walking-in-nature--heal.jpg"
                alt="Aktívni seniori v prírode"
                className="w-full h-full object-cover"
              />
            </div>
          </div>
        </div>
      </section>

      {/* Výživa a energia Section */}
      <section id="vyzhiva" className="py-20 px-4 sm:px-6 lg:px-8 bg-white">
        <div className="max-w-7xl mx-auto">
          <div className="grid lg:grid-cols-2 gap-12 items-center">
            <div className="relative h-[400px] rounded-2xl overflow-hidden shadow-xl order-2 lg:order-1">
              <img src="/fresh-healthy-food--fruits-vegetables-nuts--natura.jpg" alt="Zdravá výživa" className="w-full h-full object-cover" />
            </div>
            <div className="space-y-6 order-1 lg:order-2">
              <div className="flex items-center gap-3">
                <div className="p-3 bg-emerald-100 rounded-lg">
                  <Leaf className="h-8 w-8 text-emerald-600" />
                </div>
                <h2 className="text-3xl sm:text-4xl font-bold text-emerald-900">Výživa a energia</h2>
              </div>
              <p className="text-lg text-slate-600 leading-relaxed">
                Správna výživa je základom vitality. Naše prírodné doplnky stravy vám pomôžu udržať energiu, podporiť
                metabolizmus a cítiť sa skvele každý deň.
              </p>
              <Card className="p-6 bg-emerald-50 border-emerald-200">
                <ul className="space-y-3 text-slate-700">
                  <li className="flex items-start gap-2">
                    <span className="text-emerald-600 font-bold">✓</span>
                    <span>Prírodné vitamíny a minerály pre dennú vitalitu</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <span className="text-emerald-600 font-bold">✓</span>
                    <span>Podpora trávenia a metabolizmu</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <span className="text-emerald-600 font-bold">✓</span>
                    <span>Zvýšenie energie bez umelých stimulantov</span>
                  </li>
                </ul>
              </Card>
              <Button
                size="lg"
                className="bg-emerald-600 hover:bg-emerald-700 text-white"
                onClick={() => scrollToSection("kontakt")}
              >
                Zistite viac
              </Button>
            </div>
          </div>
        </div>
      </section>

      {/* Krvný tlak a rovnováha Section */}
      <section id="krvny-tlak" className="py-20 px-4 sm:px-6 lg:px-8 bg-sky-50/50">
        <div className="max-w-7xl mx-auto">
          <div className="grid lg:grid-cols-2 gap-12 items-center">
            <div className="space-y-6">
              <div className="flex items-center gap-3">
                <div className="p-3 bg-sky-100 rounded-lg">
                  <Activity className="h-8 w-8 text-sky-600" />
                </div>
                <h2 className="text-3xl sm:text-4xl font-bold text-emerald-900">Krvný tlak a rovnováha</h2>
              </div>
              <p className="text-lg text-slate-600 leading-relaxed">
                Udržiavanie zdravého krvného tlaku je kľúčové pre celkové zdravie. Naše produkty podporujú
                kardiovaskulárny systém prirodzenou cestou.
              </p>
              <Card className="p-6 bg-white border-sky-200">
                <ul className="space-y-3 text-slate-700">
                  <li className="flex items-start gap-2">
                    <span className="text-sky-600 font-bold">✓</span>
                    <span>Prírodná podpora zdravého krvného tlaku</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <span className="text-sky-600 font-bold">✓</span>
                    <span>Zlepšenie cirkulácie a prekrvenia</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <span className="text-sky-600 font-bold">✓</span>
                    <span>Podpora srdcového zdravia</span>
                  </li>
                </ul>
              </Card>
              <Button
                size="lg"
                className="bg-sky-600 hover:bg-sky-700 text-white"
                onClick={() => scrollToSection("kontakt")}
              >
                Objednajte si konzultáciu
              </Button>
            </div>
            <div className="relative h-[400px] rounded-2xl overflow-hidden shadow-xl">
              <img
                src="/senior-checking-blood-pressure--heart-health-monit.jpg"
                alt="Meranie krvného tlaku"
                className="w-full h-full object-cover"
              />
            </div>
          </div>
        </div>
      </section>

      {/* Kĺby a pohyb Section */}
      <section id="klby" className="py-20 px-4 sm:px-6 lg:px-8 bg-white">
        <div className="max-w-7xl mx-auto">
          <div className="grid lg:grid-cols-2 gap-12 items-center">
            <div className="relative h-[400px] rounded-2xl overflow-hidden shadow-xl order-2 lg:order-1">
              <img src="/senior-doing-yoga-stretching--joint-flexibility--a.jpg" alt="Cvičenie pre kĺby" className="w-full h-full object-cover" />
            </div>
            <div className="space-y-6 order-1 lg:order-2">
              <div className="flex items-center gap-3">
                <div className="p-3 bg-amber-100 rounded-lg">
                  <Heart className="h-8 w-8 text-amber-600" />
                </div>
                <h2 className="text-3xl sm:text-4xl font-bold text-emerald-900">Kĺby a pohyb</h2>
              </div>
              <p className="text-lg text-slate-600 leading-relaxed">
                Zdravé kĺby sú základom aktívneho života. Naše riešenia pomáhajú udržať flexibilitu, znížiť nepohodlie a
                podporiť mobilitu.
              </p>
              <Card className="p-6 bg-amber-50 border-amber-200">
                <ul className="space-y-3 text-slate-700">
                  <li className="flex items-start gap-2">
                    <span className="text-amber-600 font-bold">✓</span>
                    <span>Podpora zdravia chrupaviek a kĺbov</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <span className="text-amber-600 font-bold">✓</span>
                    <span>Zlepšenie flexibility a pohyblivosti</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <span className="text-amber-600 font-bold">✓</span>
                    <span>Prírodné zložky pre dlhodobú podporu</span>
                  </li>
                </ul>
              </Card>
              <Button
                size="lg"
                className="bg-amber-600 hover:bg-amber-700 text-white"
                onClick={() => scrollToSection("kontakt")}
              >
                Získajte radu
              </Button>
            </div>
          </div>
        </div>
      </section>

      {/* Zdravie očí Section */}
      <section id="oci" className="py-20 px-4 sm:px-6 lg:px-8 bg-indigo-50/50">
        <div className="max-w-7xl mx-auto">
          <div className="grid lg:grid-cols-2 gap-12 items-center">
            <div className="space-y-6">
              <div className="flex items-center gap-3">
                <div className="p-3 bg-indigo-100 rounded-lg">
                  <Eye className="h-8 w-8 text-indigo-600" />
                </div>
                <h2 className="text-3xl sm:text-4xl font-bold text-emerald-900">Zdravie očí</h2>
              </div>
              <p className="text-lg text-slate-600 leading-relaxed">
                Zrak je vzácny dar. Naše produkty obsahujú látky, ktoré podporujú zdravie očí a pomáhajú udržať ostrý
                zrak aj v zrelom veku.
              </p>
              <Card className="p-6 bg-white border-indigo-200">
                <ul className="space-y-3 text-slate-700">
                  <li className="flex items-start gap-2">
                    <span className="text-indigo-600 font-bold">✓</span>
                    <span>Ochrana pred oxidačným stresom</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <span className="text-indigo-600 font-bold">✓</span>
                    <span>Podpora zdravia sietnice a makuly</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <span className="text-indigo-600 font-bold">✓</span>
                    <span>Vitamíny a antioxidanty pre oči</span>
                  </li>
                </ul>
              </Card>
              <Button
                size="lg"
                className="bg-indigo-600 hover:bg-indigo-700 text-white"
                onClick={() => scrollToSection("kontakt")}
              >
                Chcem vedieť viac
              </Button>
            </div>
            <div className="relative h-[400px] rounded-2xl overflow-hidden shadow-xl">
              <img src="/senior-reading-book-with-glasses--eye-health--clea.jpg" alt="Zdravie očí" className="w-full h-full object-cover" />
            </div>
          </div>
        </div>
      </section>

      {/* Kontakt Section */}
      <section id="kontakt" className="py-20 px-4 sm:px-6 lg:px-8 bg-emerald-900 text-white">
        <div className="max-w-4xl mx-auto text-center space-y-8">
          <h2 className="text-3xl sm:text-4xl font-bold">Kontaktujte nás</h2>
          <p className="text-lg text-emerald-100 leading-relaxed">
            Máte otázky? Radi vám poradíme a pomôžeme nájsť správne riešenie pre vaše zdravie.
          </p>
          <div className="grid sm:grid-cols-3 gap-6 mt-12">
            <Card className="p-6 bg-white/10 border-white/20 backdrop-blur-sm">
              <Phone className="h-8 w-8 text-emerald-300 mx-auto mb-3" />
              <h3 className="font-semibold mb-2">Telefón</h3>
              <p className="text-emerald-100">+421 XXX XXX XXX</p>
            </Card>
            <Card className="p-6 bg-white/10 border-white/20 backdrop-blur-sm">
              <Mail className="h-8 w-8 text-emerald-300 mx-auto mb-3" />
              <h3 className="font-semibold mb-2">Email</h3>
              <p className="text-emerald-100">info@zdraviepo50.sk</p>
            </Card>
            <Card className="p-6 bg-white/10 border-white/20 backdrop-blur-sm">
              <MapPin className="h-8 w-8 text-emerald-300 mx-auto mb-3" />
              <h3 className="font-semibold mb-2">Adresa</h3>
              <p className="text-emerald-100">Bratislava, Slovensko</p>
            </Card>
          </div>
          <Button size="lg" className="bg-white text-emerald-900 hover:bg-emerald-50 px-8 py-6 text-lg mt-8">
            Napíšte nám správu
          </Button>
        </div>
      </section>

      {/* Footer */}
      <footer className="bg-emerald-950 text-emerald-100 py-12 px-4 sm:px-6 lg:px-8">
        <div className="max-w-7xl mx-auto">
          <div className="grid md:grid-cols-3 gap-8 mb-8">
            <div>
              <div className="flex items-center gap-2 mb-4">
                <Heart className="h-6 w-6 text-emerald-400" />
                <span className="text-lg font-bold text-white">Zdravie po 50</span>
              </div>
              <p className="text-sm text-emerald-200">Váš partner pre zdravý a aktívny život v zrelom veku.</p>
            </div>
            <div>
              <h3 className="font-semibold text-white mb-4">Rýchle odkazy</h3>
              <ul className="space-y-2 text-sm">
                <li>
                  <button onClick={() => scrollToSection("domov")} className="hover:text-emerald-400 transition-colors">
                    Domov
                  </button>
                </li>
                <li>
                  <button
                    onClick={() => scrollToSection("vyzhiva")}
                    className="hover:text-emerald-400 transition-colors"
                  >
                    Výživa a energia
                  </button>
                </li>
                <li>
                  <button
                    onClick={() => scrollToSection("kontakt")}
                    className="hover:text-emerald-400 transition-colors"
                  >
                    Kontakt
                  </button>
                </li>
              </ul>
            </div>
            <div>
              <h3 className="font-semibold text-white mb-4">Právne informácie</h3>
              <p className="text-xs text-emerald-200 leading-relaxed">
                Doplnky stravy nie sú určené na diagnostiku, liečbu ani prevenciu chorôb. Vždy sa poraďte so svojím
                lekárom pred použitím akýchkoľvek doplnkov.
              </p>
            </div>
          </div>
          <div className="border-t border-emerald-800 pt-8 text-center text-sm text-emerald-300">
            <p>&copy; {new Date().getFullYear()} Zdravie po 50. Všetky práva vyhradené.</p>
          </div>
        </div>
      </footer>
    </div>
  )
}
