import type React from "react"
import type { Metadata } from "next"
import { Inter, Playfair_Display } from "next/font/google"
import { Analytics } from "@vercel/analytics/next"
import "./globals.css"

const inter = Inter({ subsets: ["latin"] })
const playfair = Playfair_Display({ subsets: ["latin"] })

export const metadata: Metadata = {
  title: "Zdravie po 50 - Váš partner pre zdravý život",
  description:
    "Objavte prírodné riešenia pre zdravie, energiu a pohodu po 50-tke. Výživa, krvný tlak, kĺby a zdravie očí.",
  keywords: "zdravie po 50, wellness, výživa, krvný tlak, kĺby, zdravie očí, doplnky stravy",
  generator: "v0.app",
}

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode
}>) {
  return (
    <html lang="sk">
      <body className={`font-sans antialiased`}>
        {children}
        <Analytics />
      </body>
    </html>
  )
}
